function T = dynamic_g2_tt(T, y, x, params, steady_state, it_)
% function T = dynamic_g2_tt(T, y, x, params, steady_state, it_)
%
% File created by Dynare Preprocessor from .mod file
%
% Inputs:
%   T             [#temp variables by 1]     double  vector of temporary terms to be filled by function
%   y             [#dynamic variables by 1]  double  vector of endogenous variables in the order stored
%                                                    in M_.lead_lag_incidence; see the Manual
%   x             [nperiods by M_.exo_nbr]   double  matrix of exogenous variables (in declaration order)
%                                                    for all simulation periods
%   steady_state  [M_.endo_nbr by 1]         double  vector of steady state values
%   params        [M_.param_nbr by 1]        double  vector of parameter values in declaration order
%   it_           scalar                     double  time period for exogenous variables for which
%                                                    to evaluate the model
%
% Output:
%   T           [#temp variables by 1]       double  vector of temporary terms
%

assert(length(T) >= 266);

T = World_Economy_Cartel_corr_reserves.dynamic_g1_tt(T, y, x, params, steady_state, it_);

T(229) = T(36)+T(44)+params(21)*y(102)*exp(y(28))*params(6)*params(5)*params(5)*exp(params(5)*y(32));
T(230) = getPowerDeriv(T(9),T(10),3);
T(231) = T(138)+exp(y(13))*exp(y(13))*getPowerDeriv(exp(y(13)),params(3),2);
T(232) = T(5)*T(231);
T(233) = T(130)+T(129)+exp(y(37))*(T(128)+exp(y(37))*exp(y(37))*getPowerDeriv(exp(y(37)),T(11),3));
T(234) = y(58)*(-(T(77)*T(19)*T(16)*exp(T(1)*y(44))*(1-params(11))*params(3)*T(130)+T(5)*T(19)*T(79)*exp(T(1)*y(44))*(1-params(11))*params(3)*T(130)))+y(57)*(-(T(81)*T(3)*T(16)*exp(T(1)*y(44))*(1-params(11))*(1-params(3))*T(130)+T(17)*T(3)*T(79)*exp(T(1)*y(44))*(1-params(11))*(1-params(3))*T(130)));
T(235) = y(58)*(-(T(5)*T(19)*T(16)*(1-params(11))*params(3)*T(1)*exp(T(1)*y(44))*T(130)))+y(57)*(-(T(17)*T(3)*T(16)*(1-params(11))*(1-params(3))*T(1)*exp(T(1)*y(44))*T(130)));
T(236) = T(141)+exp(y(13))*exp(y(13))*getPowerDeriv(exp(y(13)),params(3)-1,2);
T(237) = y(58)*(-(T(5)*(T(16)*T(48)*(1-params(11))*params(3)*T(1)*exp(T(1)*y(44))*T(141)+T(19)*T(48)*(1-params(11))*params(3)*T(1)*exp(T(1)*y(44))*T(78)*T(139))))+y(57)*(-(T(17)*(T(16)*T(48)*(1-params(11))*(1-params(3))*T(1)*exp(T(1)*y(44))*T(138)+T(3)*T(48)*(1-params(11))*(1-params(3))*T(1)*exp(T(1)*y(44))*T(78)*T(139))));
T(238) = y(58)*(-(T(77)*T(19)*T(49)*T(79)+T(19)*T(16)*T(49)*T(176)+T(77)*T(19)*T(49)*T(79)+T(5)*T(19)*T(49)*T(177)))+y(57)*(-(T(81)*T(3)*T(50)*T(79)+T(17)*T(3)*T(50)*T(177)+T(81)*T(3)*T(50)*T(79)+T(3)*T(16)*T(50)*T(181)));
T(239) = y(58)*(-(T(77)*T(19)*T(16)*T(48)*(1-params(11))*params(3)*T(1)*exp(T(1)*y(44))+T(5)*T(19)*T(79)*T(48)*(1-params(11))*params(3)*T(1)*exp(T(1)*y(44))))+y(57)*(-(T(17)*T(3)*T(79)*T(48)*(1-params(11))*(1-params(3))*T(1)*exp(T(1)*y(44))+T(81)*T(3)*T(16)*T(48)*(1-params(11))*(1-params(3))*T(1)*exp(T(1)*y(44))));
T(240) = y(58)*(-(T(5)*T(19)*T(16)*T(48)*(1-params(11))*params(3)*T(1)*T(1)*exp(T(1)*y(44))))+y(57)*(-(T(17)*T(3)*T(16)*T(48)*(1-params(11))*(1-params(3))*T(1)*T(1)*exp(T(1)*y(44))));
T(241) = getPowerDeriv(T(59),T(10),3);
T(242) = T(135)+exp(y(91))*exp(y(91))*getPowerDeriv(exp(y(91)),T(11),2);
T(243) = (1-params(11))*(1-params(3))*exp(T(1)*y(96))*T(242);
T(244) = T(154)+T(153)+T(20)*(T(152)+T(20)*T(20)*getPowerDeriv(T(20),params(3),3));
T(245) = getPowerDeriv(T(55),T(1),3);
T(246) = getPowerDeriv(T(55),T(13),3);
T(247) = T(52)*T(154)*T(52)*T(53)*T(157)+T(65)*T(52)*T(244)+T(52)*T(154)*T(52)*T(53)*T(157)+T(52)*T(53)*(T(52)*T(154)*T(157)+T(52)*T(53)*T(52)*T(53)*T(246));
T(248) = T(52)*T(154)*T(157)*T(54)*T(193)+T(65)*T(154)*T(193)+T(52)*T(53)*T(157)*T(53)*T(193)+T(52)*T(53)*(T(157)*T(53)*T(193)+T(52)*T(53)*T(54)*T(193)*T(246));
T(249) = T(193)+exp(y(92))*exp(y(92))*getPowerDeriv(exp(y(92)),1-params(3),2);
T(250) = T(53)*T(193)*T(157)*T(54)*T(193)+T(65)*T(53)*T(249)+T(53)*T(193)*T(157)*T(54)*T(193)+T(52)*T(53)*(T(54)*T(193)*T(54)*T(193)*T(246)+T(157)*T(54)*T(249));
T(251) = getPowerDeriv(T(6),T(13),3);
T(252) = T(77)*T(138)*T(139)*T(144)+T(78)*T(77)*T(231)+T(77)*T(138)*T(139)*T(144)+T(3)*T(77)*(T(144)*T(232)+T(139)*T(139)*T(251));
T(253) = getPowerDeriv(T(6),T(1),3);
T(254) = getPowerDeriv(T(25),(-params(14)),2);
T(255) = T(164)*(-(params(9)*(T(162)+exp(y(14))*exp(y(14))*getPowerDeriv(exp(y(14)),1+params(8),2))/(1+params(8))))+T(163)*T(163)*T(254);
T(256) = T(26)*exp(y(15))*T(164)+T(26)*exp(y(15))*T(164);
T(257) = getPowerDeriv(T(23),(-params(14)),3);
T(258) = T(171)*T(72)*T(172)+T(73)*(-(params(9)*(T(170)+T(169)+T(4)*(T(168)+T(4)*T(4)*getPowerDeriv(T(4),1+params(8),3)))/(1+params(8))))+T(171)*T(72)*T(172)+T(72)*(T(171)*T(172)+T(72)*T(72)*T(257));
T(259) = T(176)+T(175)+T(4)*(T(174)+T(4)*T(4)*getPowerDeriv(T(4),1-params(3),3));
T(260) = T(3)*T(176)*T(3)*T(77)*T(144)+T(78)*T(3)*T(259)+T(3)*T(176)*T(3)*T(77)*T(144)+T(3)*T(77)*(T(144)*T(3)*T(176)+T(3)*T(77)*T(3)*T(77)*T(251));
T(261) = getPowerDeriv(T(85),(-params(14)),2);
T(262) = params(1)*(T(199)*(-(params(9)*(T(197)+exp(y(92))*exp(y(92))*getPowerDeriv(exp(y(92)),1+params(8),2))/(1+params(8))))+T(198)*T(198)*T(261));
T(263) = y(58)*(-(T(77)*T(19)*T(16)*T(12)*(1-params(11))*params(3)*T(1)*T(1)*exp(T(1)*y(44))+T(5)*T(19)*T(79)*T(12)*(1-params(11))*params(3)*T(1)*T(1)*exp(T(1)*y(44))));
T(264) = y(57)*(-(T(81)*T(3)*T(16)*T(12)*(1-params(11))*(1-params(3))*T(1)*T(1)*exp(T(1)*y(44))+T(17)*T(3)*T(79)*T(12)*(1-params(11))*(1-params(3))*T(1)*T(1)*exp(T(1)*y(44))));
T(265) = T(206)+exp(y(40))*exp(y(40))*T(172)+exp(y(40))*(exp(y(40))*T(172)+exp(y(40))*exp(y(40))*T(257));
T(266) = getPowerDeriv(exp(y(52)-y(45)),params(5)-1,3);

end
